var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import path from 'node:path';
import { loadFileConfig, mergeConfigs } from '../../config/configLoad.js';
import { repomixConfigCliSchema, } from '../../config/configSchema.js';
import { pack } from '../../core/packager.js';
import { rethrowValidationErrorIfZodError } from '../../shared/errorHandle.js';
import { logger } from '../../shared/logger.js';
import { printCompletion, printSecurityCheck, printSummary, printTopFiles } from '../cliPrint.js';
import Spinner from '../cliSpinner.js';
import { runMigrationAction } from './migrationAction.js';
export const runDefaultAction = (directory, cwd, options) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    logger.trace('Loaded CLI options:', options);
    // Run migration before loading config
    yield runMigrationAction(cwd);
    // Load the config file
    const fileConfig = yield loadFileConfig(cwd, (_a = options.config) !== null && _a !== void 0 ? _a : null);
    logger.trace('Loaded file config:', fileConfig);
    // Parse the CLI options into a config
    const cliConfig = buildCliConfig(options);
    logger.trace('CLI config:', cliConfig);
    // Merge default, file, and CLI configs
    const config = mergeConfigs(cwd, fileConfig, cliConfig);
    logger.trace('Merged config:', config);
    const targetPath = path.resolve(directory);
    const spinner = new Spinner('Packing files...');
    spinner.start();
    let packResult;
    try {
        packResult = yield pack(targetPath, config, (message) => {
            spinner.update(message);
        });
    }
    catch (error) {
        spinner.fail('Error during packing');
        throw error;
    }
    spinner.succeed('Packing completed successfully!');
    logger.log('');
    if (config.output.topFilesLength > 0) {
        printTopFiles(packResult.fileCharCounts, packResult.fileTokenCounts, config.output.topFilesLength);
        logger.log('');
    }
    printSecurityCheck(cwd, packResult.suspiciousFilesResults, config);
    logger.log('');
    printSummary(packResult.totalFiles, packResult.totalCharacters, packResult.totalTokens, config.output.filePath, packResult.suspiciousFilesResults, config);
    logger.log('');
    printCompletion();
    return {
        packResult,
        config,
    };
});
const buildCliConfig = (options) => {
    const cliConfig = {};
    if (options.output) {
        cliConfig.output = { filePath: options.output };
    }
    if (options.include) {
        cliConfig.include = options.include.split(',');
    }
    if (options.ignore) {
        cliConfig.ignore = { customPatterns: options.ignore.split(',') };
    }
    if (options.topFilesLen !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { topFilesLength: options.topFilesLen });
    }
    if (options.outputShowLineNumbers !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { showLineNumbers: options.outputShowLineNumbers });
    }
    if (options.copy) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { copyToClipboard: options.copy });
    }
    if (options.style) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { style: options.style.toLowerCase() });
    }
    if (options.securityCheck !== undefined) {
        cliConfig.security = { enableSecurityCheck: options.securityCheck };
    }
    if (options.fileSummary !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { fileSummary: options.fileSummary });
    }
    if (options.directoryStructure !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { directoryStructure: options.directoryStructure });
    }
    if (options.removeComments !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { removeComments: options.removeComments });
    }
    if (options.removeEmptyLines !== undefined) {
        cliConfig.output = Object.assign(Object.assign({}, cliConfig.output), { removeEmptyLines: options.removeEmptyLines });
    }
    if (options.tokenCountEncoding) {
        cliConfig.tokenCount = { encoding: options.tokenCountEncoding };
    }
    try {
        return repomixConfigCliSchema.parse(cliConfig);
    }
    catch (error) {
        rethrowValidationErrorIfZodError(error, 'Invalid cli arguments');
        throw error;
    }
};
//# sourceMappingURL=defaultAction.js.map